/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.
	
	$Id: service.c,v 1.26 2000/08/31 22:16:50 hal Exp $
____________________________________________________________________________*/
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <tchar.h>
#include <rpc.h>
#include "service.h"
#include "pgpkeysvc.h"
#include "pgpRPCMsg.h"
#include "pgpThreads.h"

#if PGP_DEBUG
void DbgPrintf(char *mesg, ...);
#else
#define DbgPrintf()
#endif

/* This mutex is also used in our polling thread, pgpRPCThread.c */
PGPMutex_t sRpcMutex;
static OSVERSIONINFO sOsid;

VOID pgpRPCServiceRun()
{
	RPC_STATUS status;
	unsigned char *pszUuid = NULL;
	unsigned char *pszProtocolSequence;
	unsigned char *pszEndpoint;
	unsigned char *pszNetworkAddress = NULL;
	unsigned char *pszSecurity = NULL;
	unsigned int cMinCalls = 1;
	unsigned int cMaxCalls = 25;
	unsigned int fDontWait = TRUE;

	sOsid.dwOSVersionInfoSize = sizeof(sOsid);
	GetVersionEx(&sOsid);

	if (sOsid.dwPlatformId == VER_PLATFORM_WIN32_NT) {
		pszProtocolSequence = "ncacn_np";
		pszEndpoint = "\\pipe\\pgpsdkserv";
	}
	else {
		pszProtocolSequence = "ncalrpc";
		pszEndpoint = "pgpsdkserv";
	}

	DbgPrintf("Calling RpcServerUseProtseqEp()");
	status = RpcServerUseProtseqEp(pszProtocolSequence, cMaxCalls, pszEndpoint, pszSecurity);
	if (status) {
		LogEvent("RpcServerUseProtseqEp() Fails.");
		return;
	}

	DbgPrintf("Calling RpcServerRegisterIf()");
	status = RpcServerRegisterIf(PgpKeyService_v1_0_s_ifspec, 0, 0);
	if (status) {
		LogEvent("RpcServerRegisterIf() Fails.");
		return;
	}

	if (sOsid.dwPlatformId == VER_PLATFORM_WIN32_NT) {
		DbgPrintf("Calling RpcServerRegisterAuthInfo()");
		status = RpcServerRegisterAuthInfo(0,
		   RPC_C_AUTHN_WINNT,
		   0,
		   0
		   );
		if (status) {
			char buf[80];
			sprintf(buf, "RpcServerRegisterAuthInfo() returns %d", status );
			LogEvent(buf);
			return;
		}
	}

	DbgPrintf("Calling RpcServerListen()");
	status = RpcServerListen(cMinCalls, cMaxCalls, fDontWait);
	if (status) {
		LogEvent("RpcServerListen() Fails.");
		return;
	}

	PGPMutexCreate(&sRpcMutex, NULL);

	SetStatus(SERVICE_RUNNING);

	LogTypeEvent(EVENTLOG_INFORMATION_TYPE, "Started Successfully");
	DbgPrintf("Started Successfully.");

	status = RpcMgmtWaitServerListen();
	if (status) {
		LogEvent("RpcMgmtWaitServerListen() Fails.");
		return;
	}
}
 
VOID pgpRPCServiceStop()
{
    // Stop's the server, wakes the main thread.

    RpcMgmtStopServerListening(0);
}

error_status_t
Ping(handle_t h)
{
    return(0);
}

error_status_t
GetPGPBuf(
		handle_t h,
		byte inBuffer[],			// INPUT
		unsigned long inBufferLen,	// INPUT
		unsigned long okayToBlock,	// INPUT
		BUFFER *pBuffer				// OUTPUT
		)
{
	int outLen;
    RPC_STATUS status;
	char *outBuffer;

	if (okayToBlock)
		PGPMutexLock(&sRpcMutex);
	else {
		if (PGPMutexTryLock(&sRpcMutex) == 1) {
			return RPC_S_ACCESS_DENIED;
		}
	}

	if (sOsid.dwPlatformId == VER_PLATFORM_WIN32_NT) {
		status = RpcImpersonateClient(h);
		if (status != RPC_S_OK) {
			LogEvent("RPC_S_ACCESS_DENIED");
			PGPMutexUnlock(&sRpcMutex);
			return RPC_S_ACCESS_DENIED;
		}

		rcv_generic(inBuffer, inBufferLen, &outBuffer, &outLen);

		RpcRevertToSelf();
	}
	else
		rcv_generic(inBuffer, inBufferLen, &outBuffer, &outLen);


    pBuffer->BufferLength = outLen;
    pBuffer->Buffer = MIDL_user_allocate(outLen);

    if (pBuffer->Buffer == 0) {
		if (!PGPIsInitRPCBuf(outBuffer))
			PGPFreeData(outBuffer);
		PGPMutexUnlock(&sRpcMutex);
        return RPC_S_OUT_OF_MEMORY;
	}
	memcpy(pBuffer->Buffer, outBuffer, outLen);
	if (!PGPIsInitRPCBuf(outBuffer))
		PGPFreeData(outBuffer);

	PGPMutexUnlock(&sRpcMutex);
    return 0;
}

void * __RPC_USER MIDL_user_allocate(size_t size)
{
    return(HeapAlloc(GetProcessHeap(), HEAP_GENERATE_EXCEPTIONS, size));
}

void __RPC_USER MIDL_user_free( void *pointer)
{
    HeapFree(GetProcessHeap(), 0, pointer);
}
